
#ifdef ACORN
#ifdef LSB_FIRST
	#define read_dword(addr)  \
	(((int)addr & 3)? \
	( ((((unsigned char *)(addr))[0])) | \
	  ((((unsigned char *)(addr))[1]) <<  8) | \
	  ((((unsigned char *)(addr))[2]) << 16) | \
	  ((((unsigned char *)(addr))[3]) << 24) ) \
	  : (*(int *)addr) )
	#define write_dword(addr,value)  \
	(((int)addr & 3)? \
	( ((unsigned char *)(addr))[0] = (unsigned char)((int)(value)), \
	  ((unsigned char *)(addr))[1] = (unsigned char)((int)(value) >>  8), \
	  ((unsigned char *)(addr))[2] = (unsigned char)((int)(value) >> 16), \
	  ((unsigned char *)(addr))[3] = (unsigned char)((int)(value) >> 24) ) \
	  : (*(int *)addr = value) )
#else
	#define read_dword(address) (((int)address & 3)?(*((unsigned char *)address+3) | (*((unsigned char *)address+2) << 8) | (*((unsigned char *)address+1) << 16) | (*((unsigned char *)address) << 24) ) : (*(int *)address) )
	INLINE void write_dword(int *address, int data)
	{
	  	if ((int)address & 3)
		{
	    		*((unsigned char *)address+3) =  data;
	    		*((unsigned char *)address+2) = (data >> 8);
	    		*((unsigned char *)address+1) = (data >> 16);
	    		*((unsigned char *)address)   = (data >> 24);
			return;
	  	}
	  	else
			*(int *)address = data;
	}
#endif
#else
#define read_dword(address) *(int *)address
#define write_dword(address,data) *(int *)address=data
#endif


static __inline void gp32_sound_mixer_channel_single_step (signed char *stream, int len, struct lpWaves *waves) {
	
	int sample_pos=0;
	int sample_len=waves->len;
	signed char *sample_data=waves->lpData;
	signed char *sample_data_pos=sample_data;
	
	while (len) {
		if(sample_pos<(sample_len-4) && len>3) {
			len-=4;
			write_dword((int *)stream, read_dword((int *)sample_data_pos) ^ 0x80808080);
			stream+=4;
			sample_data_pos+=4;
		} else {
			len--;
			*stream++=(*sample_data_pos++)^0x80;
			sample_pos++;
		}
		if(sample_pos==sample_len) {
			sample_pos=0;
			sample_data_pos=sample_data;
		}
	}
}

static __inline void gp32_sound_mixer_channel_single_nostep (signed char *stream, int len, struct lpWaves *waves) {
	
	int i;
	int sample_pos;
	int sample_len=waves->len;
	int sample_freq=waves->freq;
	signed char *sample_data=waves->lpData;
	unsigned int my_dw;

	for (i=0;((int)stream&3);i++) {
		sample_pos = (i*sample_freq)/sample_rate;
		while(sample_pos>=sample_len)
			sample_pos-=sample_len;
		*stream++=sample_data[sample_pos]^0x80;
	}		
	for(;i<len-4;i++) {

		my_dw=0;
		
		sample_pos = (i*sample_freq)/sample_rate;
		while(sample_pos>=sample_len)
			sample_pos-=sample_len;
		my_dw|=((unsigned char *)(sample_data))[sample_pos];
		i++;
		
		sample_pos = (i*sample_freq)/sample_rate;
		while(sample_pos>=sample_len)
			sample_pos-=sample_len;
		my_dw|=((unsigned char *)(sample_data))[sample_pos]<<8;
		i++;
				
		sample_pos = (i*sample_freq)/sample_rate;
		while(sample_pos>=sample_len)
			sample_pos-=sample_len;
		my_dw|=((unsigned char *)(sample_data))[sample_pos]<<16;
		i++;

		sample_pos = (i*sample_freq)/sample_rate;
		while(sample_pos>=sample_len)
			sample_pos-=sample_len;
		my_dw|=((unsigned char *)(sample_data))[sample_pos]<<24;

		*(unsigned int *)stream=my_dw^0x80808080;
		stream+=4;
	}
	for (;i<len;i++) {
		sample_pos = (i*sample_freq)/sample_rate;
		while(sample_pos>=sample_len)
			sample_pos-=sample_len;
		*stream++=sample_data[sample_pos]^0x80;
	}		
}

static __inline void gp32_sound_mixer_channel_single_nostep_96k (unsigned char *stream, int len, struct lpWaves *waves) {
	
	int i;
	int sample_pos=0;
	int sample_len=sb.samples;
	unsigned char *sample_data=waves->lpData;
	unsigned char *sample_data_find=sample_data;
	int *sample_loc=sound_96k;
	int *sample_loc_find=sample_loc;
	unsigned int my_dw;

	if (sample_rate == LO_RATE)
	{
		sample_loc=sound_11k_96k;
		sample_loc_find=sample_loc;
	}

	for (i=0;((int)stream&3);i++) {
		*stream++=(*(sample_data+*sample_loc))^0x80;
		sample_data+=*sample_loc++;
		sample_pos++;
		if (sample_pos==sample_len) {
			sample_pos==0;
			sample_data=sample_data_find;
			sample_loc=sample_loc_find;
		}
	}		
	for(;i<len-4;i+=4) {
		my_dw=(*(sample_data+*sample_loc));
		sample_data+=*sample_loc++;
		sample_pos++;
		if (sample_pos==sample_len) {
			sample_pos==0;
			sample_data=sample_data_find;
			sample_loc=sample_loc_find;
		}
		my_dw|=(*(sample_data+*sample_loc))<<8;
		sample_data+=*sample_loc++;
		sample_pos++;
		if (sample_pos==sample_len) {
			sample_pos==0;
			sample_data=sample_data_find;
			sample_loc=sample_loc_find;
		}
		my_dw|=(*(sample_data+*sample_loc))<<16;
		sample_data+=*sample_loc++;
		sample_pos++;
		if (sample_pos==sample_len) {
			sample_pos==0;
			sample_data=sample_data_find;
			sample_loc=sample_loc_find;
		}
		my_dw|=(*(sample_data+*sample_loc))<<24;
		sample_data+=*sample_loc++;
		sample_pos++;
		if (sample_pos==sample_len) {
			sample_pos==0;
			sample_data=sample_data_find;
			sample_loc=sample_loc_find;
		}
		*(unsigned int *)stream=my_dw^0x80808080;
		stream+=4;
	}
	for (;i<len;i++) {
		*stream++=(*(sample_data+*sample_loc))^0x80;
		sample_data+=*sample_loc++;
		sample_pos++;
		if (sample_pos==sample_len) {
			sample_pos==0;
			sample_data=sample_data_find;
			sample_loc=sample_loc_find;
		}
	}		
}

static __inline void gp32_sound_mixer_channel_step (signed char *stream, int len, struct lpWaves *waves, int flags, int t) {

	int sample;
	int sample_pos=0;
	int sample_len=waves->len;
	int sample_vol=waves->volume;
	signed char *sample_data=waves->lpData;
	signed char *sample_data_pos=sample_data;

	if (flags==1) {
		/* First channel */
		while (len--) {
			/* Update sample*/
			sample=((*sample_data_pos++)*(sample_vol))>>6;
			/* Increase sample position */
			sample_pos++;
			if (sample_pos==sample_len) {
				sample_pos=0;
				sample_data_pos=sample_data;
			}
			/* Scale and mix sample */
			switch (t) {
				case 8:
				case 7:
				case 6:	*stream++=(sample>>3); break;
				case 5:
				case 4:
				case 3: *stream++=(sample>>2); break;
				default: *stream++=(sample>>1); break;
			}
		}
	} else if (flags==2) {
		/* Last channel */
		while (len--) {
			/* Update sample*/
			sample=((*sample_data_pos++)*(sample_vol))>>6;
			/* Increase sample position */
			sample_pos++;
			if (sample_pos==sample_len) {
				sample_pos=0;
				sample_data_pos=sample_data;
			}
			/* Scale and mix sample */
			switch (t) {
				case 8:
				case 7:
				case 6: *stream+=(sample>>3)^0x80; break;
				case 5:
				case 4:
				case 3: *stream+=(sample>>2)^0x80; break;
				default: *stream+=(sample>>1)^0x80; break;
			}
			/* Next sample */
			stream++;
		}
	} else if (flags==3) {
		/* Single channel */
		while (len--) {
			/* Update sample*/
			sample=((*sample_data_pos++)*(sample_vol))>>6;
			/* Increase sample position */
			sample_pos++;
			if (sample_pos==sample_len) {
				sample_pos=0;
				sample_data_pos=sample_data;
			}
			/* Scale and mix sample */
			switch (t) {
				case 8:
				case 7:
				case 6: *stream++=(sample>>3)^0x80; break;
				case 5:
				case 4:
				case 3: *stream++=(sample>>2)^0x80; break;
				case 2: *stream++=(sample>>1)^0x80; break;
				default: *stream++=(sample)^0x80; break;
			}
		}
	} else {
		/* Normal channel */
		while (len--) {
			/* Update sample*/
			sample=((*sample_data_pos++)*(sample_vol))>>6;
			/* Increase sample position */
			sample_pos++;
			if (sample_pos==sample_len) {
				sample_pos=0;
				sample_data_pos=sample_data;
			}
			/* Scale and mix sample */
			switch (t) {
				case 8:
				case 7:
				case 6: *stream+=(sample>>3); break;
				case 5:
				case 4:
				case 3: *stream+=(sample>>2); break;
				default: *stream+=(sample>>1); break;
			}
			/* Next sample */
			stream++;
		}
	}
}

static __inline void gp32_sound_mixer_channel_nostep (signed char *stream, int len, struct lpWaves *waves, int flags, int t) {
	
	int i;
	int sample;
	int sample_pos;
	int sample_len=waves->len;
	int sample_vol=waves->volume;
	int sample_freq=waves->freq;
	signed char *sample_data=waves->lpData;

	if (flags==1) {
		/* First channel */
		for(i=0;i<len;i++) {
			/* Update sample position */
			sample_pos = (i*sample_freq)/sample_rate;
			while(sample_pos>=sample_len)
				sample_pos-=sample_len;	
			/* Update sample */
			sample=((sample_data[sample_pos])*(sample_vol))>>6;
			/* Scale and mix sample */
			switch (t) {
				case 8:
				case 7:
				case 6: *stream++=(sample>>3); break;
				case 5:
				case 4:
				case 3: *stream++=(sample>>2); break;
				default: *stream++=(sample>>1); break;
			}
		}		
	} else if (flags==2) {
		/* Last channel */
		for(i=0;i<len;i++) {
			/* Update sample position */
			sample_pos = (i*sample_freq)/sample_rate;
			while(sample_pos>=sample_len)
				sample_pos-=sample_len;	
			/* Update sample */
			sample=((sample_data[sample_pos])*(sample_vol))>>6;
			/* Scale and mix sample */
			switch (t) {
				case 8:
				case 7:
				case 6: *stream+=(sample>>3)^0x80; break;
				case 5:
				case 4:
				case 3: *stream+=(sample>>2)^0x80; break;
				default: *stream+=(sample>>1)^0x80; break;
			}
			/* Next sample */
			stream++;
		}		
	} else if (flags==3) {
		/* Single channel */
		for(i=0;i<len;i++) {
			/* Update sample position */
			sample_pos = (i*sample_freq)/sample_rate;
			while(sample_pos>=sample_len)
				sample_pos-=sample_len;	
			/* Update sample */
			sample=((sample_data[sample_pos])*(sample_vol))>>6;
			/* Scale and mix sample */
			switch (t) {
				case 8:
				case 7:
				case 6: *stream++=(sample>>3)^0x80; break;
				case 5:
				case 4:
				case 3: *stream++=(sample>>2)^0x80; break;
				case 2: *stream++=(sample>>1)^0x80; break;
				default: *stream++=(sample)^0x80; break;
			}
		}		
	} else {
		/* Normal channel */
		for(i=0;i<len;i++) {
			/* Update sample position */
			sample_pos = (i*sample_freq)/sample_rate;
			while(sample_pos>=sample_len)
				sample_pos-=sample_len;	
			/* Update sample */
			sample=((sample_data[sample_pos])*(sample_vol))>>6;
			/* Scale and mix sample */
			switch (t) {
				case 8:
				case 7:
				case 6: *stream+=(sample>>3); break;
				case 5:
				case 4:
				case 3: *stream+=(sample>>2); break;
				default: *stream+=(sample>>1); break;
			}
			/* Next sample */
			stream++;
		}		
	}
}
